'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Button_Abbruch_Click()
On Error GoTo Err_Button_Abbruch_Click


    DoCmd.Close

Exit_Button_Abbruch_Click:
    Exit Sub

Err_Button_Abbruch_Click:
    MsgBox err.Description
    Resume Exit_Button_Abbruch_Click
    
End Sub

Private Sub Button_OK_Click()

    'Variablen deklarieren
    Dim dbs As Database
    Dim rst As Recordset
    Dim FilterText As String
    Dim KommaPosition As Long
    
    'Gltigkeitsprfungen
    If (IsNull(Me.Steuersatz.Value) Or (Trim(Me.Steuersatz.Value) = "")) Then
        MsgBox "Bitte geben Sie einen Prozentwert ein!", vbCritical, "Fehler"
        Me.Steuersatz.SetFocus
        Exit Sub
    End If
    If (IsNull(Me.Bezeichnung.Value) Or (Trim(Me.Bezeichnung.Value) = "")) Then
        MsgBox "Bitte geben Sie eine Bezeichnung ein!", vbCritical, "Fehler"
        Me.Bezeichnung.SetFocus
        Exit Sub
    End If
    
    On Error GoTo ErrorSteuersatzAnlegenFehler
    
    'Filterzeichenkette vorbereiten
    FilterText = Format(Me.Steuersatz.Value, "0.00")
    KommaPosition = InStr(FilterText, ",")
    If (KommaPosition <> 0) Then
        FilterText = Left(FilterText, KommaPosition - 1) & "." & Mid(FilterText, KommaPosition + 1)
    End If
    FilterText = "SELECT * FROM Steuersaetze WHERE [Prozent] = " & FilterText
    
    'Tabelle ffnen und nachsehen, ob Prozentwert bereis vorhanden ist
    Set dbs = CurrentDb
    Set rst = dbs.OpenRecordset(FilterText)
    If (rst.RecordCount) = 0 Then
    
        'Hinweis zum Warten anzeigen
        'DoCmd.OpenForm "Bitte_warten"
        'Forms![Bitte_warten].Repaint
    
        'Steuersatz anlegen
        rst.AddNew
        rst!Prozent = Me.Steuersatz.Value
        rst!Bezeichnung = Trim(Left(Me.Bezeichnung.Value, 50))
        rst.Update
        rst.Close
    Else
        'wenn Prozentwert bereits vorhanden
        MsgBox "Dieser Steuersatz ist bereits vorhanden! Bitte geben Sie einen anderen Prozentwert ein.", vbCritical, "Fehler"
        Me.Steuersatz.SetFocus
        Exit Sub
    End If
    
ExitSteuersatzAnlegen:
    Set rst = Nothing
    Set dbs = Nothing
    
    'Aufrufendes Formular zwecks Aktualisierung schlieen und wieder ffnen
    'DoCmd.Close acForm, FormularName, acSaveYes
    'DoCmd.OpenForm FormularName
    'Anzeige aktualisieren
    Forms![Einstellungen_2].[Steuersaetze].Form.Requery
    
    'sich selbst schlieen
    DoCmd.Close acForm, "Steuersatz_neu", acSaveYes
    
    Exit Sub
    
    
ErrorSteuersatzAnlegenFehler:
        MsgBox "Beim Speichern des Steuersatzes trat ein Fehler auf!", vbCritical, "Fehler"
        MsgBox err.Description
        Resume ExitSteuersatzAnlegen

End Sub

Private Sub Steuersatz_Exit(Cancel As Integer)
    If (IsNull(Me.Steuersatz.Value) Or (Trim(Me.Steuersatz.Value) = "")) Then Exit Sub
    Me.Steuersatz.Value = Format(Me.Steuersatz.Value, "#,##0.00")
End Sub
